# OS/8 Combined (Unified) Kit

This subtree builds the OS/8 Combined Kit from source into a variety
of distribution media images.

It is signifcant because it is the latest, greatest, official distribution of OS/8.

The kit is described in Software Product Description (S.P.D. 4.4.5)
which can be found starting at page 21 of the October-November 1980
PDP-8 Digital Software News AA-K629A-BA.

The SPD defines the minimum hardware requirement as: PDP-8/a, /e, or /m
with 12K words of memory or DECStation 88/80, /90, /92, or /97, with
RK8J or RL8A disk. That said, we believe this system will run on a
single TD8E DECtape system, it should run fine on PDP-8/I hardware, and
with a little fiddling with old device drivers, it should support an
RF08 disk.

The OS/8 Combined Kit Information Guide (order number AA-J016B-TA)
describes the kit in an overview section as follows:

    As the name implies, the kit is a combination of OS/8 software
    products. It includes the software and documentation contained in
    the following kits:

      o  OS/8, Version 3D, Operating System (described in Software
         Product Description (S.P.D. 4.1.11)

      o  OS/8, Version 3D, Extension (S.P.D. 4.5.8)

      o  OS/8, Version 3D, Device Extensions for RL01, RX02, and KT8A
         (S.P.D. 4.12.0)

      o  OS/8, Version 3D, FORTRAN IV (S.P.D. 4.10.7)

    In addition, the kit's modules have been updated with the binary
    patches described in the OS/8 Device Extensions User's Guide and in
    the issues of the Digital Software News (through June 1979).
    

It details documentation appropriate to the kit as follows:

    OS/8 COMBINED KIT INFORMATION GUIDE - AA-J016B-TA
        Describes the kit's contents and how to get the system
        on line.

    OS/8 COMBINED KIT - V3D SPD 4.4.2
        Describes the OS/8 Combined Kit, its options,
        licenses, support category and other pertinent
        information.

    OS/8 DEVICE EXTENSION RELEASE NOTES - AA-H565A-TA
        Contains supplemental information on the features of
        the OS/8 Device Extensions Kit not discussed in the
        DEVICE EXTENSIONS USER'S GUIDE.

    OS/8 DEVICE EXTENSIONS USER'S GUIDE - AA-D319A-TA
        Describes the RL01 and RX02 disks, their bootstrap
        procedures, and the software support for the KT8A
        (128K) Memory Management option.

    OS/8 ERROR MESSAGES - AA-H610A-TA
            Describes the error messages generated by the OS/8
            Monitor and its system programs.

    OS/8 FORTRAN IV SOFTWARE SUPPORT MANUAL - DEC-S8-LFSSA-A-D
        Describes internal features of OS/8 FORTRAN IV that
        may be useful to the advanced user.

    OS/8 LANGUAGE REFERENCE MANUAL - AA-H609A-TA
        Describes the languages supported by OS/8: BASIC,
        FORTRAN IV, PAL8, FORTRAN II, FLAP/RALF, and SABR.

    OS/8 MARK SENSE BATCH USER'S MANUAL - DEC-S8-OBUGA-A-D
        Describes the use and operation of the Mark Sense
        Batch (MSBATCH) OS/8 system program. It includes
        step-by-step procedures for preparing programs for
        submission to MSBATCH.

    OS/8 SOFTWARE SUPPORT MANUAL - DEC-S8-OSSMB-A-D
        Describes internal system features that may be useful
        to the advanced user.

    OS/8 SYSTEM GENERATION NOTES - AA-H606A-TA
        Describes PDP-8/E bootstrap procedures for LINCtape,
        DECtape (TC08 and TD8E), and disk (DF32, RF08, RK08,
        RK8E, and RX01), as well as procedures for building
        the system from paper tape and DECassette (TA8E).

    OS/8 SYSTEM REFERENCE MANUAL - AA-H607A-TA
        Describes the OS/8 system conventions, keyboard
        commands and utility programs.

    OS/8 TECO REFERENCE MANUAL - AA-H608A-TA
        Describes the Text Editing and Correcting program for
        OS/8 users.

    OS/8 V3D SYSTEM RELEASE NOTES - DEC-S8-OSRNA-B-D
        Describes the differences between version V3D of OS/8
        and previous versions, as well as corrections to known
        software problems.

    TECO POCKET GUIDE - AV-D530A-TK
        Contains a guick-reference summary of OS/8 TECO
        commands.

### <a id="license"></a>License

Copyright © 2020 by Bill Cattey. Licensed under the terms of
[the SIMH license][sl].
