# USB Stick Labels

## What It Is

This directory contains an Inkscape document (`*.svg`) containing the
DECtape logo and USB stick labels with graphics based on that label.
There are three example labels in the document:

*   **BIN Loader** for `media/copytoUSBsticks/binloader.pt`
*   **FOCAL-69** for `media/copytoUSBsticks/focal.pt`
*   **ADD.PA** for `examples/add.pt`

These labels use the "DECtape" graphics even though they're paper tapes,
primarily because it's a nice graphic and I haven't bothered to draw
something appropriate to paper tapes yet.

The labels print out at approximately 30×16mm each, which fits the USB
sticks I have here, but you may need to scale the printout for your
particular USB sticks.


## Affixing the Labels

This document is not designed with any particular self-adhesive label
stock in mind. Instead, I simply use rubber cement as a contact adhesive
to affix these labels to the USB stick.

Simply cut the label(s) you want to use out with scissors, paint both
the back of the label and the top of the USB stick with rubber cement,
and let it dry for a minute or so. When the glue is dry-looking,
carefully place the label where you want it on the USB stick. You won't
have much of a chance to move the label around after the two dried glue
patches touch, so be careful with your placement.

Press the label firmly against the stick, pressing repeatedly to cover
the entire surface, then rub around the label gently to brush away any
excess cement.

Protip: Use the part of the page you cut the labels out of as a
protective mat to work on. It will let you apply cement to the label
fully edge-to-edge without messing up your work surface. The labels will
be much more durable if there is no unglued bit near the edge for
fingernails and such to snag on. You were going to throw this excess
material away, so you might as well get one final use out of it, yes?


## Fonts

This SVG file uses a non-free font called [Dottie][font] for the faux
dot matrix text. There are [free alternatives][alt], but none of the
ones I liked allow redistribution, so I couldn't include one of them in
this repository.

[font]: https://www.fonts.com/font/ingrimayne-type/dottie/regular
[alt]:  http://www.1001fonts.com/digital+dot-matrix-fonts.html


## PDF Version

If you don't want to use one of those alternative fonts or simply like
the look of Dottie and don't need custom labels, this directory also
includes a PDF of the same design with the necessary subset of Dottie
embedded, so that you can print it out.
